# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 8
# Experiment: PMxPM, Run: 2
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR8_strategy.txt
# LLM Suggested Fallback: Not Provided

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR8(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    total_rounds = 10
    
    # Check for deterministic opponent strategies
    always_cooperate = "always cooperate" in opponent_program_code.lower() or "return 'C'" in opponent_program_code.lower()
    always_defect = "always defect" in opponent_program_code.lower() or "return 'D'" in opponent_program_code.lower()
    if always_cooperate:
        return "D"
    if always_defect:
        return "D"
    
    # Initial rounds (1-3)
    if current_round == 1:
        return "C"
    elif current_round <= 3:
        if opp_history[-1] == "D":
            return "D"
        else:
            return "C"
    
    # Mid-game (4-7)
    elif current_round <= 7:
        # Check opponent's behavior in first 3 rounds
        opp_first_three = opp_history[:3]
        c_count = opp_first_three.count("C")
        d_count = opp_first_three.count("D")
        
        if c_count >= 2:
            # If opponent cooperated in at least 2 of first 3 rounds
            if len(opp_history) >= 2 and opp_history[-1] == "D" and opp_history[-2] == "D":
                return "D"
            else:
                return "C"
        else:
            # Opponent defected in 2 or more of first 3 rounds
            if current_round <= 5:
                return "D"
            else:
                # Reassess
                recent_opp = opp_history[-2:] if len(opp_history) >= 2 else opp_history
                if recent_opp.count("D") >= 1:
                    return "D"
                else:
                    return "C"
    
    # Late game (8-10)
    else:
        total_c = opp_history.count("C")
        total_d = opp_history.count("D")
        
        if total_c >= 5:
            return "C"
        elif total_d >= 5:
            return "D"
        else:
            # Close case, alternate
            if current_round % 2 == 0:
                return "D"
            else:
                return "C"